#ifndef DLISTVIEW_ESTILOS_H
    #define DLISTVIEW_ESTILOS_H

    #include "DBaseControlWin.h"
    #include "DBaseWnd_Estilos.h"

    namespace DWL {

        class DListView_Estilos : public DBaseWnd_Estilos {
          public :
                                DListView_Estilos(DWORD nEstilos = NULL) : DBaseWnd_Estilos(nEstilos) { 
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_ALIGNLEFT"),          LVS_ALIGNLEFT));                // 0x0800                  
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_ALIGNMASK"),          LVS_ALIGNMASK));                // 0x0c00                         
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_ALIGNTOP"),           LVS_ALIGNTOP));                 // 0x0000 LVS_ICON             
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_AUTOARRANGE"),        LVS_AUTOARRANGE));              // 0x0100                        
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_EDITLABELS"),         LVS_EDITLABELS));               // 0x0200      
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_ICON"),               LVS_ICON));                     // 0x0000 LVS_ALIGNTOP   
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_LIST"),               LVS_LIST));                     // 0x0003 LVS_TYPEMASK     
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_NOCOLUMNHEADER"),     LVS_NOCOLUMNHEADER));           // 0x4000                
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_NOLABELWRAP"),        LVS_NOLABELWRAP));              // 0x0080                
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_NOSCROLL"),           LVS_NOSCROLL));                 // 0x2000     
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_NOSORTHEADER"),       LVS_NOSORTHEADER));             // 0x8000                           
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_OWNERDATA"),          LVS_OWNERDATA));                // 0x1000             
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_OWNERDRAWFIXED"),     LVS_OWNERDRAWFIXED));           // 0x0400                    
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_REPORT"),             LVS_REPORT));                   // 0x0001           
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SHAREIMAGELISTS"),    LVS_SHAREIMAGELISTS));          // 0x0040                      
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SHOWSELALWAYS"),      LVS_SHOWSELALWAYS));            // 0x0008                  
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SINGLESEL"),          LVS_SINGLESEL));                // 0x0004                
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SMALLICON"),          LVS_SMALLICON));                // 0x0002                
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SORTASCENDING"),      LVS_SORTASCENDING));            // 0x0010                    
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_SORTDESCENDING"),     LVS_SORTDESCENDING));           // 0x0020                   
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_TYPEMASK"),           LVS_TYPEMASK));                 // 0x0003 LVS_LIST             
                                    _DatosEstilos.push_back(DEstilo(TEXT("LVS_TYPESTYLEMASK"),      LVS_TYPESTYLEMASK));            // 0xfc00 (LVS_NOCOLUMNHEADER | LVS_NOSORTHEADER)
                                };
                                DWL_DEFINIR_ESTILO(LVS_AlignLeft,       27);
                                DWL_DEFINIR_ESTILO(LVS_AlignMask,       28);
                                DWL_DEFINIR_ESTILO(LVS_AlignTop,        29);
                                DWL_DEFINIR_ESTILO(LVS_AutoArrange,     30);
                                DWL_DEFINIR_ESTILO(LVS_EditLabels,      31);
                                DWL_DEFINIR_ESTILO(LVS_Icon,            32);
                                DWL_DEFINIR_ESTILO(LVS_List,            33);
                                DWL_DEFINIR_ESTILO(LVS_NoColumnHeader,  34);
                                DWL_DEFINIR_ESTILO(LVS_NoLabelWrap,     35);
                                DWL_DEFINIR_ESTILO(LVS_NoScroll,        36);
                                DWL_DEFINIR_ESTILO(LVS_NoSortHeader,    37);
                                DWL_DEFINIR_ESTILO(LVS_OwnerData,       38);
                                DWL_DEFINIR_ESTILO(LVS_OwnerDrawFixed,  39);
                                DWL_DEFINIR_ESTILO(LVS_Report,          40);
                                DWL_DEFINIR_ESTILO(LVS_ShareImageLists, 41);
                                DWL_DEFINIR_ESTILO(LVS_ShowSelAlways,   42);
                                DWL_DEFINIR_ESTILO(LVS_SingleSel,       43);
                                DWL_DEFINIR_ESTILO(LVS_SmallIcon,       44);
                                DWL_DEFINIR_ESTILO(LVS_SortAscending,   45);
                                DWL_DEFINIR_ESTILO(LVS_SortDescending,  46);
                                DWL_DEFINIR_ESTILO(LVS_TypeMask,        47);
                                DWL_DEFINIR_ESTILO(LVS_TypeStyleMask,   48);

            inline DWORD       operator() (void)                { return _Estilos; };
            DListView_Estilos  &operator = (DWORD nEstilos)     { _Estilos = nEstilos; return *this; };
        };  

        class DListView_EstilosEx : public DEstilos {
          public :
                                    DListView_EstilosEx(DWORD nEstilos = NULL) : DEstilos(nEstilos) { 
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_AUTOAUTOARRANGE"),         LVS_EX_AUTOAUTOARRANGE));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_AUTOCHECKSELECT"),         LVS_EX_AUTOCHECKSELECT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_AUTOSIZECOLUMNS"),         LVS_EX_AUTOSIZECOLUMNS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_BORDERSELECT"),            LVS_EX_BORDERSELECT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_CHECKBOXES"),              LVS_EX_CHECKBOXES));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_COLUMNOVERFLOW"),          LVS_EX_COLUMNOVERFLOW));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_COLUMNSNAPPOINTS"),        LVS_EX_COLUMNSNAPPOINTS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_DOUBLEBUFFER"),            LVS_EX_DOUBLEBUFFER));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_FLATSB"),                  LVS_EX_FLATSB));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_FULLROWSELECT"),           LVS_EX_FULLROWSELECT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_GRIDLINES"),               LVS_EX_GRIDLINES));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_HEADERDRAGDROP"),          LVS_EX_HEADERDRAGDROP));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_HEADERINALLVIEWS"),        LVS_EX_HEADERINALLVIEWS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_HIDELABELS"),              LVS_EX_HIDELABELS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_INFOTIP"),                 LVS_EX_INFOTIP));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_JUSTIFYCOLUMNS"),          LVS_EX_JUSTIFYCOLUMNS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_LABELTIP"),                LVS_EX_LABELTIP));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_MULTIWORKAREAS"),          LVS_EX_MULTIWORKAREAS));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_REGIONAL"),                LVS_EX_REGIONAL));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_SIMPLESELECT"),            LVS_EX_SIMPLESELECT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_SINGLEROW"),               LVS_EX_SINGLEROW));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_SNAPTOGRID"),              LVS_EX_SNAPTOGRID));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_SUBITEMIMAGES"),           LVS_EX_SUBITEMIMAGES));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_TRACKSELECT"),             LVS_EX_TRACKSELECT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_TRANSPARENTBKGND"),        LVS_EX_TRANSPARENTBKGND));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_TRANSPARENTSHADOWTEXT"),   LVS_EX_TRANSPARENTSHADOWTEXT));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_TWOCLICKACTIVATE"),        LVS_EX_TWOCLICKACTIVATE));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_UNDERLINECOLD"),           LVS_EX_UNDERLINECOLD));                                
                                        _DatosEstilos.push_back(DEstilo(TEXT("LVS_EX_UNDERLINEHOT"),            LVS_EX_UNDERLINEHOT));                                
                                    };
                                    DWL_DEFINIR_ESTILO(LVS_EX_AutoAutoArrange,          0);
                                    DWL_DEFINIR_ESTILO(LVS_EX_AutoCheckSelect,          1);
                                    DWL_DEFINIR_ESTILO(LVS_EX_AutoSizeColumns,          2);
                                    DWL_DEFINIR_ESTILO(LVS_EX_BorderSelect,             3);
                                    DWL_DEFINIR_ESTILO(LVS_EX_CheckBoxes,               4);
                                    DWL_DEFINIR_ESTILO(LVS_EX_ColumnOverflow,           5);
                                    DWL_DEFINIR_ESTILO(LVS_EX_ColumnSnapPoints,         6);
                                    DWL_DEFINIR_ESTILO(LVS_EX_DoubleBuffer,             7);
                                    DWL_DEFINIR_ESTILO(LVS_EX_FlatSB,                   8);
                                    DWL_DEFINIR_ESTILO(LVS_EX_FullRowSelect,            9);
                                    DWL_DEFINIR_ESTILO(LVS_EX_GridLines,                10);
                                    DWL_DEFINIR_ESTILO(LVS_EX_HeaderDragDrop,           11);
                                    DWL_DEFINIR_ESTILO(LVS_EX_HeaderInAllViews,         12);
                                    DWL_DEFINIR_ESTILO(LVS_EX_HideLabels,               13);
                                    DWL_DEFINIR_ESTILO(LVS_EX_InfoTip,                  14);
                                    DWL_DEFINIR_ESTILO(LVS_EX_JustifyColumns,           15);
                                    DWL_DEFINIR_ESTILO(LVS_EX_LabelTip,                 16);
                                    DWL_DEFINIR_ESTILO(LVS_EX_MultiWorkAreas,           17);
                                    DWL_DEFINIR_ESTILO(LVS_EX_OneClickActivate,         18);
                                    DWL_DEFINIR_ESTILO(LVS_EX_Regional,                 19);
                                    DWL_DEFINIR_ESTILO(LVS_EX_SimpleSelect,             20);
                                    DWL_DEFINIR_ESTILO(LVS_EX_SingleRow,                21);
                                    DWL_DEFINIR_ESTILO(LVS_EX_SnapToGrid,               22);
                                    DWL_DEFINIR_ESTILO(LVS_EX_SubItemImages,            23);
                                    DWL_DEFINIR_ESTILO(LVS_EX_TrackSelect,              24);
                                    DWL_DEFINIR_ESTILO(LVS_EX_TransparentBkgnd,         25);
                                    DWL_DEFINIR_ESTILO(LVS_EX_TransparentShadowText,    26);
                                    DWL_DEFINIR_ESTILO(LVS_EX_TwoClickActivate,         27);
                                    DWL_DEFINIR_ESTILO(LVS_EX_UnderLineCold,            28);
                                    DWL_DEFINIR_ESTILO(LVS_EX_UnderLineHot,             29);

            inline DWORD           operator() (void)                { return _Estilos; };
            DListView_EstilosEx    &operator = (DWORD nEstilos)     { _Estilos = nEstilos; return *this; };
        };


        #define DWL_ESTILOS_EX_LISTVIEW    (LVS_EX_AUTOAUTOARRANGE | LVS_EX_AUTOCHECKSELECT | LVS_EX_AUTOSIZECOLUMNS | LVS_EX_BORDERSELECT | LVS_EX_CHECKBOXES | LVS_EX_COLUMNOVERFLOW | LVS_EX_COLUMNSNAPPOINTS |      \
                                            LVS_EX_DOUBLEBUFFER | LVS_EX_FLATSB | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_HEADERDRAGDROP | LVS_EX_HEADERINALLVIEWS | LVS_EX_HIDELABELS | LVS_EX_INFOTIP |      \
                                            LVS_EX_JUSTIFYCOLUMNS | LVS_EX_LABELTIP | LVS_EX_MULTIWORKAREAS | LVS_EX_ONECLICKACTIVATE | LVS_EX_REGIONAL | LVS_EX_SIMPLESELECT | LVS_EX_SINGLEROW | LVS_EX_SNAPTOGRID |  \
                                            LVS_EX_SUBITEMIMAGES | LVS_EX_TRACKSELECT | LVS_EX_TRANSPARENTBKGND | LVS_EX_TRANSPARENTSHADOWTEXT | LVS_EX_TWOCLICKACTIVATE | LVS_EX_UNDERLINECOLD | LVS_EX_UNDERLINEHOT)

    };

#endif